import asyncio
from pathlib import Path
import pandas as pd
from sqlalchemy import text
from database.db import async_session

# مسیر ذخیره گزارش
REPORT_DIR = Path("data/reports")
REPORT_DIR.mkdir(parents=True, exist_ok=True)
CSV_PATH = REPORT_DIR / "user_phones_report.csv"

async def export_user_phones_csv():
    async with async_session() as session:
        result = await session.execute(
            text("SELECT user_id, phone_number, username, created_at FROM user_phones")
        )
        rows = [dict(r) for r in result.mappings().all()]

    if not rows:
        print("❌ هیچ رکوردی در دیتابیس یافت نشد.")
        return

    df = pd.DataFrame(rows)

    # نوشتن CSV
    try:
        df.to_csv(CSV_PATH, index=False, encoding="utf-8-sig")
        print(f"✅ فایل CSV ساخته شد: {CSV_PATH.resolve()}")
    except Exception as e:
        print(f"❌ خطا در ساخت CSV: {e}")

# اجرای Async
asyncio.run(export_user_phones_csv())
