# database/db.py
import os
from dotenv import load_dotenv
from sqlalchemy.ext.asyncio import create_async_engine, async_sessionmaker
from database.models import UnlimitedRotationGroup
from sqlalchemy import select

# ⬅️ ایمپورت همان Base که در models.py تعریف کرده‌اید
from database.models import Base  # noqa: E402  (باید قبل از create_all در حافظه باشد)

load_dotenv()
_raw = os.getenv("DATABASE_PATH", "./data/database.db")

# ---------- تبدیل به URL کامل ----------
if _raw.startswith("sqlite"):            # کاربر URL کامل داده است
    DATABASE_URL = _raw
else:                                    # فقط مسیر فایل است
    if _raw.startswith("/"):             # مسیر مطلق
        DATABASE_URL = f"sqlite+aiosqlite://{_raw}"
    else:                                # مسیر نسبی
        DATABASE_URL = f"sqlite+aiosqlite:///{_raw}"

# ---------- Engine & Session ----------
engine = create_async_engine(DATABASE_URL, echo=False, future=True)
async_session = async_sessionmaker(engine, expire_on_commit=False)

# ---------- init_db ----------
async def init_db() -> None:
    """
    تمام مدل‌ها قبلاً با import بالا در متادیتا ثبت شده‌اند؛
    این تابع جدول‌هایی را که وجود ندارند می‌سازد.
    """
    # اطمینان از اینکه همهٔ مدل‌ها لود شده‌اند (در صورت تغییر lazy imports)
    import database.models  # noqa: F401

    async with engine.begin() as conn:
        await conn.run_sync(Base.metadata.create_all, checkfirst=True)





async def seed_rotation_groups() -> None:
    starts = [0, 5, 10, 15, 20, 25]
    async with async_session() as session:
        for sd in starts:
            # بررسی وجود
            exists = await session.execute(
                select(UnlimitedRotationGroup).where(UnlimitedRotationGroup.start_day == sd)
            )
            if not exists.scalar_one_or_none():
                session.add(UnlimitedRotationGroup(
                    start_day=sd,
                    end_day=sd + 4,
                    discount_percent=10.0
                ))
        await session.commit()