# config.py
from dotenv import load_dotenv
import os

# بارگذاری خودکار متغیرهای .env
load_dotenv()

# توکن بات
BOT_TOKEN = os.getenv("BOT_TOKEN")

# مسیر دیتابیس
DATABASE_PATH = os.getenv("DATABASE_PATH", "./data/database.db")

# یوزرنیم ادمین پشتیبانی (بدون @)
SUPPORT_ADMIN_USERNAME = "Mushak_vpn_admin"

# 🔐 شناسهٔ عددی ادمین‌های تلگرام
# اگر متغیر ADMINS در .env تعریف شده باشد از آن استفاده می‌کنیم،
# وگرنه از این لیست پیش‌فرض:

_DEFAULT_ADMINS = [
    1028775319,   # ادمین اصلی
    # 987654321,  # ادمین دوم (اختیاری)
]

# خواندن لیست ADMINS از .env و تبدیل به اعداد صحیح
_env_admins = os.getenv("ADMINS", "")
if _env_admins:
    # اگر در .env تعریف شده باشد، آن را به لیست عددی تبدیل می‌کنیم
    ADMINS = [
        int(i.strip()) for i in _env_admins.split(",") if i.strip().isdigit()
    ]
else:
    # در صورت نبودن، از لیست پیش‌فرض استفاده می‌کنیم
    ADMINS = _DEFAULT_ADMINS
