from database.db import async_session
from database.models import UserPhone
from sqlalchemy import select

async def is_user_verified(user_id: int) -> bool:
    async with async_session() as session:
        result = await session.execute(
            select(UserPhone).where(UserPhone.user_id == user_id)
        )
        return result.scalar_one_or_none() is not None
