from cryptography.fernet import Fernet
from pathlib import Path

# مسیر فایل کلید
_KEY_PATH = Path("key.key")

# اگر فایل کلید وجود ندارد، خودکار یک کلید جدید تولید و ذخیره کن
if not _KEY_PATH.exists():
    print("🔑 key.key not found. Generating new encryption key...")
    new_key = Fernet.generate_key()
    _KEY_PATH.write_bytes(new_key)
    # ایمن‌سازی دسترسی فایل (اختیاری، در لینوکس)
    try:
        _KEY_PATH.chmod(0o600)
    except Exception:
        pass  # اگر سیستم‌عامل اجازه نداد، صرفاً نادیده بگیر

# بارگذاری کلید
with _KEY_PATH.open("rb") as key_file:
    _fernet = Fernet(key_file.read())


def encrypt_bytes(data: bytes) -> bytes:
    """
    رمزنگاری بایت‌ها با استفاده از کلید موجود در key.key.
    """
    return _fernet.encrypt(data)


def decrypt_bytes(token: bytes) -> bytes:
    """
    رمزگشایی بایت‌ها با استفاده از کلید موجود در key.key.
    """
    return _fernet.decrypt(token)
