# bot/states/states.py
from aiogram.fsm.state import StatesGroup, State

# 📌 استیت‌های مربوط به مدیریت سفارش توسط ادمین
class AdminOrderStates(StatesGroup):
    waiting_for_new_expiration_date = State()

# 📌 استیت‌های مربوط به اطلاع‌رسانی توسط ادمین
class AdminNotificationStates(StatesGroup):
    waiting_for_message = State()

# 📌 استیت‌های مربوط به خرید/پرداخت کاربر
class Purchase(StatesGroup):
    choosing_plan = State()       # از purchase.py منتقل شد
    waiting_receipt = State()

# 📌 استیت‌های مربوط به کد تخفیف
class DiscountStates(StatesGroup):
    waiting_discount_code = State()
    
# 📌 استیت مربوط به ماژولار کردن اطلاعات پرداخت در پنل ادمین 
class PaymentEditStates(StatesGroup):
    waiting_for_card = State()
    waiting_for_holder = State()
