# bot/keyboards/shared.py

from aiogram.types import InlineKeyboardMarkup, InlineKeyboardButton
from config import SUPPORT_ADMIN_USERNAME

def get_support_button(label: str = "📞 تماس با پشتیبانی") -> InlineKeyboardMarkup:
    """
    ساخت کیبورد با دکمه‌ای که کاربر را به پیوی ادمین هدایت می‌کند.
    """
    return InlineKeyboardMarkup(
        inline_keyboard=[
            [
                InlineKeyboardButton(
                    text=label,
                    url=f"https://t.me/{SUPPORT_ADMIN_USERNAME}"
                )
            ]
        ]
    )

def get_user_panel_keyboard() -> InlineKeyboardMarkup:
    """
    کیبورد منوی اصلی کاربر با دکمه‌های:
    - اشتراک من
    - بازگشت به منو
    - خرید پلن
    - راهنما
    """
    kb = InlineKeyboardMarkup(inline_keyboard=[])

    # ردیف اول: اشتراک من و بازگشت به منو
    kb.inline_keyboard.append([
        InlineKeyboardButton(
            text="🔄 اشتراک من",
            callback_data="user:my_subscription"
        ),
        InlineKeyboardButton(
            text="🏠 منو",
            callback_data="user:menu"
        ),
    ])

    # ردیف دوم: خرید پلن و راهنما
    kb.inline_keyboard.append([
        InlineKeyboardButton(
            text="🛒 خرید پلن",
            callback_data="user:buy_plan"
        ),
        InlineKeyboardButton(
            text="❓ راهنما",
            callback_data="user:help"
        ),
    ])

    return kb


def get_free_test_button(label: str = "🎁 دریافت تست رایگان") -> InlineKeyboardMarkup:
    return InlineKeyboardMarkup(
        inline_keyboard=[
            [
                InlineKeyboardButton(
                    text=label,
                    url=f"https://t.me/{SUPPORT_ADMIN_USERNAME}"
                )
            ]
        ]
    )
