# bot/keyboards/admin.py
from aiogram.types import InlineKeyboardMarkup, InlineKeyboardButton
from aiogram.utils.keyboard import InlineKeyboardBuilder
from database.models import Plan, PlanCategory, Order
from database.queries import get_plan_by_id

def link_category_keyboard(categories: list[PlanCategory]) -> InlineKeyboardMarkup:
    buttons = [
        [ InlineKeyboardButton(text=cat.title, callback_data=f"admin:link:cat:{cat.id}") ]
        for cat in categories
    ]
    buttons.append([ InlineKeyboardButton(text="🔙 بازگشت", callback_data="admin:link:menu") ])
    return InlineKeyboardMarkup(inline_keyboard=buttons)

# ─────────── منوی اصلی ادمین ───────────
def admin_main_menu() -> InlineKeyboardMarkup:
    kb = InlineKeyboardBuilder()
    kb.button(text="➕ افزودن دسته‌بندی پلن", callback_data="admin:add_category")
    kb.button(text="➕ افزودن پلن",          callback_data="admin:add_plan")
    kb.button(text="📋 مدیریت دسته‌ها و پلن‌ها", callback_data="admin:list_categories")
    kb.button(text="👥 لیست کاربران فعال",       callback_data="admin:list_users")
    kb.button(text="🤑 تایید رسیدها",        callback_data="admin:pending_orders")
    kb.button(text="❌ سفارشات بدون لینک",    callback_data="admin:no_link_orders")
    kb.button(text="🌐 مدیریت لینک‌ها",      callback_data="admin:link:menu")
    kb.button(text="💌 اطلاع‌رسانی",              callback_data="admin:notify_menu")
    kb.row(
        InlineKeyboardButton(text="🔍  جستجو لینک", callback_data="admin:link:search")
    )
    kb.button(text="📊 گزارش فروش ماهانه", callback_data="admin:monthly_report")
    kb.button(text="🎟 مدیریت کد تخفیف",   callback_data="admin:discount_menu")
    kb.button(text="🔔 اطلاع‌رسانی تمدید اشتراک‌ها", callback_data="admin:renew_notify_menu")
    kb.button(text="💳 مدیریت اطلاعات پرداخت", callback_data="admin:payment_menu")
    kb.button(text="🔄 ریست دیتابیس",       callback_data="admin:reset_db")
    kb.button(text="🗑 پاک‌سازی رسیدها", callback_data="admin:cleanup")
    kb.button(text="🧹 پاکسازی کش", callback_data="admin:clear_cache")
    kb.button(text="🙋🏻‍♂️ نمایش لیست کامل کاربرها",callback_data="admin:get_contacts")
    kb.button(text="📡 تنظیمات وبهوک", callback_data="admin:webhook_menu")
    kb.button(text="🧾 گزارش خطاهای وبهوک", callback_data="admin:webhook:errors")
    kb.button(text="💾 Export DB", callback_data="admin:trigger_backup")
    kb.button(text="📥 Import DB", callback_data="admin:trigger_restore")


    kb.adjust(2)
    return kb.as_markup()



# ─────────── منوی مدیریت کد تخفیف ───────────
def discount_menu_keyboard() -> InlineKeyboardMarkup:
    kb = InlineKeyboardBuilder()
    kb.button(text="➕ افزودن کد تخفیف", callback_data="admin:discount:add")
    kb.button(text="📋 مشاهده کدها", callback_data="admin:discount:list")
    kb.button(text="🔍 جستجو کد", callback_data="admin:discount:search")
    kb.button(text="🗑 حذف کد تخفیف", callback_data="admin:discount:delete")
    kb.button(text="🔙 بازگشت", callback_data="admin:main_menu")
    kb.adjust(1)
    return kb.as_markup()



# ─────────── انتخاب نوع (حجمی / نامحدود) ───────────
def category_type_keyboard() -> InlineKeyboardMarkup:
    return InlineKeyboardMarkup(
        inline_keyboard=[[
            InlineKeyboardButton(text="📦 حجمی",    callback_data="admin:type:volume"),
            InlineKeyboardButton(text="♾ نامحدود", callback_data="admin:type:unlimited")
        ]]
    )

# ─────────── کیبورد نوع لینک (حجمی/نامحدود) ───────────
def link_type_keyboard() -> InlineKeyboardMarkup:
    return InlineKeyboardMarkup(
        inline_keyboard=[[
            InlineKeyboardButton(text="📦 حجمی",    callback_data="admin:link:type:volume"),
            InlineKeyboardButton(text="♾ نامحدود", callback_data="admin:link:type:unlimited")
        ]]
    )

# ─────────── فهرست دسته‌ها (مدیریت) ───────────
def categories_manage_keyboard(categories: list[PlanCategory]) -> InlineKeyboardMarkup:
    kb = InlineKeyboardBuilder()
    for cat in categories:
        kb.button(text=f"{cat.title} ({cat.type})", callback_data=f"admin:editcat:{cat.id}")
    kb.button(text="🔙 بازگشت", callback_data="admin:back")
    kb.adjust(1)
    return kb.as_markup()

# ─────────── فهرست پلن‌های یک دسته ───────────
def plans_keyboard(plans: list[Plan], category_id: int) -> InlineKeyboardMarkup:
    kb = InlineKeyboardBuilder()
    for p in plans:
        kb.button(
            text=f"{p.name} – {int(p.price)}ت",
            callback_data=f"admin:plan:{p.id}:{category_id}",
        )
    kb.button(text="🔙 بازگشت به دسته‌ها", callback_data="admin:list_categories")
    kb.adjust(1)
    return kb.as_markup()

# ─────────── عملیات روی پلن ───────────
from aiogram.utils.keyboard import InlineKeyboardBuilder
from aiogram.types import InlineKeyboardMarkup

def plan_actions_keyboard(plan_id: int, category_id: int, is_full: bool) -> InlineKeyboardMarkup:
    kb = InlineKeyboardBuilder()

    kb.button(
        text="✏️ ویرایش",
        callback_data=f"admin:plan_edit:{plan_id}:{category_id}"
    )
    kb.button(
        text="💡 رفع تکمیل ظرفیت" if is_full else "💡 تکمیل ظرفیت",
        callback_data=f"admin:toggle_plan:{plan_id}:{category_id}:{int(not is_full)}"
    )
    kb.button(
        text="🗑 حذف",
        callback_data=f"admin:plan_del:{plan_id}:{category_id}"
    )
    kb.button(
        text="🔙 بازگشت به دسته‌ها",
        callback_data="admin:list_categories"
    )

    kb.adjust(2)
    return kb.as_markup()


# ─────────── انتخاب فیلد پلن برای ویرایش ───────────
def edit_field_keyboard(plan_id: int, category_id: int) -> InlineKeyboardMarkup:
    kb = InlineKeyboardBuilder()
    kb.button(text="عنوان",      callback_data=f"admin:editfield:name:{plan_id}:{category_id}")
    kb.button(text="قیمت",       callback_data=f"admin:editfield:price:{plan_id}:{category_id}")
    kb.button(text="توضیح",      callback_data=f"admin:editfield:description:{plan_id}:{category_id}")
    kb.button(text="تعداد کاربر",callback_data=f"admin:editfield:user_limit:{plan_id}:{category_id}")
    kb.button(text="🔙 بازگشت",  callback_data=f"admin:plan:{plan_id}:{category_id}")
    kb.adjust(2)
    return kb.as_markup()

# ─────────── عملیات روی دسته ───────────
from database.models import PlanCategory, Plan
from aiogram.utils.keyboard import InlineKeyboardBuilder
from aiogram.types import InlineKeyboardMarkup, InlineKeyboardButton

def category_actions_keyboard(cat: PlanCategory) -> InlineKeyboardMarkup:
    kb = InlineKeyboardBuilder()
    kb.button(text="✏️ ویرایش عنوان/نوع",    callback_data=f"admin:cat_edit:{cat.id}")
    kb.button(text=f"💡 {'رفع تکمیل ظرفیت' if cat.is_full else 'تکمیل ظرفیت'}",
              callback_data=f"admin:toggle_cat:{cat.id}:{int(not cat.is_full)}")
    kb.button(text="🗑 حذف دسته",              callback_data=f"admin:cat_del:{cat.id}")
    kb.button(text="👁 مشاهدهٔ پلن‌ها",        callback_data=f"admin:catview:{cat.id}")
    kb.button(text="🔙 بازگشت",               callback_data="admin:list_categories")
    kb.adjust(2)
    return kb.as_markup()


# ─────────── فیلدهای دسته برای ویرایش ───────────
def category_edit_field_keyboard(category_id: int) -> InlineKeyboardMarkup:
    kb = InlineKeyboardBuilder()
    kb.button(text="عنوان",                 callback_data=f"admin:cat_field:title:{category_id}")
    kb.button(text="نوع (حجمی/نامحدود)",    callback_data=f"admin:cat_field:type:{category_id}")
    kb.button(text="🔙 بازگشت",             callback_data=f"admin:editcat:{category_id}")
    kb.adjust(2)
    return kb.as_markup()

# ─────────── فهرست سفارش‌های در انتظار ───────────
async def build_pending_orders_keyboard(orders: list[Order]) -> InlineKeyboardMarkup:
    kb = InlineKeyboardBuilder()
    for o in orders:
        plan = await get_plan_by_id(o.plan_id)
        plan_name = plan.name if plan else "نامشخص"
        kb.button(text=f"#{o.id} کاربر:{o.user_id} پلن:{plan_name}", callback_data=f"admin:order:{o.id}")
    kb.button(text="🔙 بازگشت به منوی اصلی", callback_data="admin:back")
    kb.adjust(1)
    return kb.as_markup()

# ─────────── عملیات روی یک سفارش ───────────
def order_action_keyboard(order_id: int) -> InlineKeyboardMarkup:
    return InlineKeyboardMarkup(
        inline_keyboard=[
            [
                InlineKeyboardButton(text="✅ تأیید", callback_data=f"admin:order_approve:{order_id}"),
                InlineKeyboardButton(text="❌ رد",   callback_data=f"admin:order_reject:{order_id}"),
            ],
            [InlineKeyboardButton(text="🔙 بازگشت به لیست", callback_data="admin:pending_orders")]
        ]
    )

# ─────────── منوی مدیریت لینک‌ها ───────────
def link_pool_menu() -> InlineKeyboardMarkup:
    kb = InlineKeyboardBuilder()
    kb.button(text="🔍 نمایش لینک‌ها",    callback_data="admin:link:list")
    kb.button(text="➕ افزودن لینک جدید", callback_data="admin:link:add")
    kb.button(text="🔙 بازگشت",           callback_data="admin:back")
    kb.adjust(1)
    return kb.as_markup()

# ─────────── دکمۀ «بازگشت» به منوی لینک‌ها ───────────
def back_to_link_pool_menu() -> InlineKeyboardMarkup:
    return InlineKeyboardMarkup(
        inline_keyboard=[[InlineKeyboardButton(text="🔙 بازگشت", callback_data="admin:link:menu")]]
    )



def no_link_order_actions_keyboard(order_id: int) -> InlineKeyboardMarkup:
    return InlineKeyboardMarkup(
        inline_keyboard=[
            [
                InlineKeyboardButton(
                    text="📎 اختصاص لینک",
                    callback_data=f"admin:assign_link_select:{order_id}"
                )
            ],
            [
                InlineKeyboardButton(
                    text="🔙 بازگشت",
                    callback_data="admin:no_link_orders"
                )
            ]
        ]
    )

# گزارش ماهانه فروش 
from aiogram.types import InlineKeyboardMarkup, InlineKeyboardButton

def monthly_report_choice_keyboard() -> InlineKeyboardMarkup:
    return InlineKeyboardMarkup(inline_keyboard=[
        [
            InlineKeyboardButton(text="📋 نمایش در چت", callback_data="admin:monthly_inline"),
            InlineKeyboardButton(text="📄 دریافت فایل CSV", callback_data="admin:monthly_file"),
        ],
        [
            InlineKeyboardButton(text="🔙 بازگشت", callback_data="admin:back")
        ]
    ])


# bot/keyboards/admin.py
from aiogram.utils.keyboard import InlineKeyboardBuilder

def admin_active_users_kb() -> InlineKeyboardMarkup:
    builder = InlineKeyboardBuilder()
    # دکمه‌های مورد نظر
    builder.button(text="🔙 بازگشت", callback_data="admin:main_menu")
    builder.button(text="🔍 جستجو", callback_data="admin:search_user")
    # تنظیم تا دو دکمه در هر ردیف
    builder.adjust(2)
    return builder.as_markup()



from aiogram.types import InlineKeyboardMarkup, InlineKeyboardButton

# bot/keyboards/admin.py
def back_to_user_subs_kb(user_id: int) -> InlineKeyboardMarkup:
    return InlineKeyboardMarkup(inline_keyboard=[[
        InlineKeyboardButton(
            text="🔙 بازگشت",
            callback_data=f"admin:user_subs:{user_id}"
        )
    ]])


# ماژولار کردن اطلاعات پرداخت در پنل ادمین
def payment_config_keyboard() -> InlineKeyboardMarkup:
    kb = InlineKeyboardBuilder()
    kb.button(text="✏️ ویرایش شماره کارت", callback_data="admin:payment:edit_card")
    kb.button(text="✏️ ویرایش نام صاحب حساب", callback_data="admin:payment:edit_holder")
    kb.button(text="🔙 بازگشت", callback_data="admin:main_menu")
    kb.adjust(1)
    return kb.as_markup()



from aiogram.types import InlineKeyboardMarkup, InlineKeyboardButton
from typing import List
from math import ceil

def build_pending_orders_keyboard(
    orders: List,
    page: int,
    page_size: int,
    total: int,
    *,
    query: dict | None = None
) -> InlineKeyboardMarkup:
    """
    orders: لیست سفارش‌ها (Order objects)
    page: شماره صفحه (1-based)
    page_size: اندازه صفحه (مثلاً 10)
    total: تعداد کل موارد (برای ساخت دکمه‌های prev/next)
    query: اگر جستجو انجام شده، همین dict را پاس بده تا در callback نگه داشته شود
    """
    rows = []
    for o in orders:
        plan_name = getattr(o.plan, "name", "-") if getattr(o, "plan", None) else "-"

        if getattr(o.user, "username", None):
            user_label = f"@{o.user.username}"
        else:
            user_label = "👤 بدون یوزرنیم"

        text = f"#{o.id} — {plan_name}"

        rows.append([
            InlineKeyboardButton(
                text=text,
                callback_data=f"admin:order:{o.id}"
            )
        ])

    # controls row: search, clear_search (if query), back
    ctrl_row = [
        InlineKeyboardButton(text="🔍 جستجو", callback_data="admin:pending:search_start"),
        InlineKeyboardButton(text="🔙 بازگشت", callback_data="admin:back")
    ]
    if query:
        # دکمه برای پاک کردن فیلتر و بازگشت به صفحه 1
        ctrl_row.insert(1, InlineKeyboardButton(text="❌ پاک‌سازی فیلتر", callback_data="admin:pending:clear_search"))
    rows.append(ctrl_row)

    # pagination row
    total_pages = max(1, ceil(total / page_size))
    pag_row = []
    if page > 1:
        pag_row.append(InlineKeyboardButton(text="⬅️ قبلی", callback_data=f"admin:pending:page:{page-1}"))
    # نمایش شماره صفحه به‌صورت فقط یک دکمه اطلاعاتی (callback ندارد)
    pag_row.append(InlineKeyboardButton(text=f"صفحه {page}/{total_pages}", callback_data=f"admin:pending:page:{page}"))
    if page < total_pages:
        pag_row.append(InlineKeyboardButton(text="بعدی ➡️", callback_data=f"admin:pending:page:{page+1}"))
    rows.append(pag_row)

    return InlineKeyboardMarkup(inline_keyboard=rows)