# bot/handlers/admin_notify.py
from aiogram import Router, F
from aiogram.types import CallbackQuery
from bot.keyboards.admin_notify import notify_menu_keyboard
from bot.utils.cron import toggle_cron_status, get_cron_status
from bot.utils.renewal_notifier import send_renewal_notifications

router = Router()


# ─────────── نمایش منوی اطلاع‌رسانی تمدید ───────────
@router.callback_query(F.data == "admin:renew_notify_menu")
async def renew_notify_menu_handler(callback: CallbackQuery):
    """نمایش منوی اطلاع‌رسانی تمدید"""
    is_active = await get_cron_status()
    kb = notify_menu_keyboard(is_active)

    await callback.message.edit_text(
        "📢 <b>مدیریت اطلاع‌رسانی تمدید اشتراک‌ها</b>\n"
        "از اینجا می‌توانید کرون اطلاع‌رسانی را فعال/غیرفعال کنید یا به‌صورت دستی اجرا کنید.",
        reply_markup=kb,
        parse_mode="HTML"
    )
    await callback.answer()


# ─────────── فعال / غیرفعال کردن کرون ───────────
@router.callback_query(F.data == "admin:toggle_cron")
async def toggle_cron_handler(callback: CallbackQuery):
    """فعال یا غیرفعال کردن وضعیت کرون اطلاع‌رسانی تمدید"""
    new_status = await toggle_cron_status()
    status_text = "🟢 فعال شد" if new_status else "🔴 غیرفعال شد"

    kb = notify_menu_keyboard(new_status)
    await callback.message.edit_text(
        "📢 <b>مدیریت اطلاع‌رسانی تمدید اشتراک‌ها</b>\n"
        "از اینجا می‌توانید کرون اطلاع‌رسانی را فعال/غیرفعال کنید یا به‌صورت دستی اجرا کنید.",
        reply_markup=kb,
        parse_mode="HTML"
    )

    await callback.answer(f"وضعیت کرون: {status_text}", show_alert=True)


# ─────────── اجرای دستی اطلاع‌رسانی ───────────
@router.callback_query(F.data == "admin:run_manual_notify")
async def manual_notify_handler(callback: CallbackQuery):
    """اجرای دستی اطلاع‌رسانی تمدید برای کاربران"""
    await callback.answer("در حال اجرای اطلاع‌رسانی...", show_alert=False)

    result = await send_renewal_notifications(callback.bot)

    sent_count = result.get("sent_count", 0)
    failed_count = result.get("failed_count", 0)
    total_checked = result.get("total_checked", 0)
    duration = result.get("duration", 0)

    await callback.message.answer(
        f"🚀 <b>گزارش اطلاع‌رسانی تمدید</b>\n\n"
        f"👥 کل بررسی‌شده‌ها: <b>{total_checked}</b>\n"
        f"✅ ارسال موفق: <b>{sent_count}</b>\n"
        f"⚠️ خطا: <b>{failed_count}</b>\n"
        f"⏱ مدت زمان اجرا: <b>{duration} ثانیه</b>",
        parse_mode="HTML"
    )
