import os
import sys
from logging.config import fileConfig

from sqlalchemy import engine_from_config, pool
from alembic import context
from dotenv import load_dotenv

# --------------------------
# بارگذاری متغیرهای محیطی از فایل .env
# --------------------------
load_dotenv()

# --------------------------
# اضافه کردن مسیر پروژه به sys.path
# تا ماژول‌های داخلی قابل ایمپورت باشند
# --------------------------
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..')))

# --------------------------
# دریافت تنظیمات Alembic از فایل alembic.ini
# --------------------------
config = context.config

# --------------------------
# تنظیم سیستم لاگ
# --------------------------
if config.config_file_name:
    fileConfig(config.config_file_name)

# --------------------------
# تنظیم URL پایگاه‌داده از طریق متغیر محیطی
# --------------------------
db_path = os.getenv("DATABASE_PATH", "./data/database.db")
db_url = f"sqlite:///{db_path}"
config.set_main_option("sqlalchemy.url", db_url)

# --------------------------
# وارد کردن metadata مدل‌ها برای autogenerate
# --------------------------
from database.models import Base
target_metadata = Base.metadata

# --------------------------
# اجرای مهاجرت در حالت آفلاین
# --------------------------
def run_migrations_offline() -> None:
    context.configure(
        url=db_url,
        target_metadata=target_metadata,
        literal_binds=True,
        dialect_opts={"paramstyle": "named"},
    )
    with context.begin_transaction():
        context.run_migrations()

# --------------------------
# اجرای مهاجرت در حالت آنلاین
# --------------------------
def run_migrations_online() -> None:
    connectable = engine_from_config(
        config.get_section(config.config_ini_section, {}),
        prefix="sqlalchemy.",
        poolclass=pool.NullPool,
    )
    with connectable.connect() as connection:
        context.configure(
            connection=connection,
            target_metadata=target_metadata,
            render_as_batch=True
        )
        with context.begin_transaction():
            context.run_migrations()

# --------------------------
# انتخاب بین حالت آنلاین و آفلاین
# --------------------------
if context.is_offline_mode():
    run_migrations_offline()
else:
    run_migrations_online()
